/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.enums;

import java.util.Locale;

public enum GlobalScriptEvent {
    ON_TOP,
    ON_DROP,
    BEGIN_DIALOG,
    END_DIALOG,
    NEW_SESSION,
    PRE_PROCESSING,
    POST_PROCESSING,
    PRE_LOGGING,
    PRE_MATCHING,
    TIMED_OUT_SESSION,
    ON_SOLUTION_LOADED,
    ON_SOLUTION_UNLOAD;


    public static final GlobalScriptEvent fromEngineEvent(String eventName) {
        switch (eventName.toLowerCase(Locale.ENGLISH)) {
            case "ontop": {
                return ON_TOP;
            }
            case "ondrop": {
                return ON_DROP;
            }
            case "begindialog": {
                return BEGIN_DIALOG;
            }
            case "enddialog": {
                return END_DIALOG;
            }
            case "newsession": {
                return NEW_SESSION;
            }
            case "preprocessing": {
                return PRE_PROCESSING;
            }
            case "postprocessing": {
                return POST_PROCESSING;
            }
            case "prelogging": {
                return PRE_LOGGING;
            }
            case "prematching": {
                return PRE_MATCHING;
            }
            case "timedoutsession": {
                return TIMED_OUT_SESSION;
            }
            case "onsolutionloaded": 
            case "onknowledgebaseloaded": {
                return ON_SOLUTION_LOADED;
            }
            case "onsolutionunload": 
            case "onsolutionunloaded": 
            case "onknowledgebaseunload": {
                return ON_SOLUTION_UNLOAD;
            }
        }
        throw new IllegalArgumentException("Invalid event name: " + eventName);
    }

    public final String toEngineEvent() {
        switch (this) {
            case ON_TOP: {
                return "ontop";
            }
            case ON_DROP: {
                return "ondrop";
            }
            case BEGIN_DIALOG: {
                return "begindialog";
            }
            case END_DIALOG: {
                return "enddialog";
            }
            case NEW_SESSION: {
                return "newsession";
            }
            case PRE_PROCESSING: {
                return "preprocessing";
            }
            case POST_PROCESSING: {
                return "postprocessing";
            }
            case PRE_LOGGING: {
                return "prelogging";
            }
            case PRE_MATCHING: {
                return "prematching";
            }
            case TIMED_OUT_SESSION: {
                return "timedoutsession";
            }
            case ON_SOLUTION_LOADED: {
                return "onsolutionloaded";
            }
            case ON_SOLUTION_UNLOAD: {
                return "onsolutionunload";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.name());
    }
}

