/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.exceptions;

import com.artisol.teneo.studio.api.enums.ErrorCode;
import com.artisol.teneo.studio.api.models.ErrorInfo;
import java.io.IOException;

public class ResourceException
extends IOException {
    private ErrorInfo errorInfo = new ErrorInfo(ErrorCode.UNKNOWN_EXCEPTION);

    public ResourceException(ErrorInfo errorInfo) {
        super(errorInfo.getDetails());
        this.errorInfo = errorInfo;
    }

    public ResourceException(ErrorCode errorCode) {
        this.errorInfo.setErrorCode(errorCode);
    }

    public ResourceException(String message) {
        super(message);
        this.errorInfo.setDetails(message);
    }

    public ResourceException(String message, ErrorCode errorCode) {
        super(message);
        this.errorInfo.setErrorCode(errorCode);
        this.errorInfo.setDetails(message);
    }

    public ResourceException(Throwable cause) {
        super(cause);
        this.errorInfo.setDetails(cause.getMessage());
    }

    public ResourceException(Throwable cause, ErrorCode errorCode) {
        super(cause);
        this.errorInfo.setErrorCode(errorCode);
    }

    public ResourceException(String message, Throwable cause) {
        super(message, cause);
        this.errorInfo.setDetails(cause.getMessage());
    }

    public ResourceException(String message, Throwable cause, ErrorCode errorCode) {
        super(message, cause);
        this.errorInfo.setErrorCode(errorCode);
        this.errorInfo.setDetails(cause.getMessage());
    }

    public ErrorCode getErrorCode() {
        return this.errorInfo.getErrorCode();
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public String toString() {
        return "ResourceException { errorCode=" + this.errorInfo.getErrorCode() + ", message=" + this.getMessage() + " }";
    }
}

