/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.models;

import com.artisol.teneo.studio.api.enums.DocumentType;
import com.artisol.teneo.studio.api.enums.ErrorCode;
import com.artisol.teneo.studio.api.models.LockInfo;
import com.artisol.teneo.studio.api.models.headers.Header;
import java.util.List;

public class ErrorInfo {
    private ErrorCode errorCode;
    private String details;
    private List<LockInfo> locks;
    private List<Header> documentsInUse;
    private DocumentType documentType;
    private String path;
    private String name;
    private String userId;

    public ErrorInfo() {
    }

    public ErrorInfo(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public ErrorInfo(ErrorCode errorCode, String details) {
        this.errorCode = errorCode;
        this.details = details;
    }

    public ErrorInfo(List<LockInfo> locks, DocumentType documentType, String path) {
        this.errorCode = ErrorCode.ALREADY_LOCKED;
        this.locks = locks;
        this.documentType = documentType;
        this.path = path;
    }

    public ErrorInfo(List<Header> documentsInUse) {
        this.errorCode = ErrorCode.DOCUMENT_IN_USE;
        this.documentsInUse = documentsInUse;
    }

    public ErrorInfo(DocumentType documentType, String name) {
        this.errorCode = ErrorCode.NAME_NOT_UNIQUE;
        this.documentType = documentType;
        this.name = name;
    }

    public ErrorInfo(String userId) {
        this.errorCode = ErrorCode.DOCUMENT_ALREADY_UNDER_TEST;
        this.userId = userId;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getDetails() {
        return this.details;
    }

    public List<LockInfo> getLocks() {
        return this.locks;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setLocks(List<LockInfo> locks) {
        this.locks = locks;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<Header> getDocumentsInUse() {
        return this.documentsInUse;
    }

    public void setDocumentsInUse(List<Header> documentsInUse) {
        this.documentsInUse = documentsInUse;
    }
}

