/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.models.publish;

import com.artisol.teneo.studio.api.enums.PublishEnvironmentType;
import com.artisol.teneo.studio.api.enums.PublishType;
import com.artisol.teneo.studio.api.models.VersionInfo;
import com.artisol.teneo.studio.api.models.Versionable;
import com.artisol.teneo.studio.api.models.publish.PublishTarget;
import com.artisol.teneo.studio.api.models.publish.ScriptResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class PublishEnvironment
extends Versionable {
    private String name;
    private String description;
    private UUID publishPackageId;
    private int autoTestThreshold;
    private String dueDiligenceConfirmation;
    private String vaUrl;
    private boolean published = false;
    private PublishEnvironmentType environmentType = PublishEnvironmentType.DEV;
    private boolean allowRepublishToOtherEnvironment = false;
    private String publishPostScripts;
    private PublishType type;
    private Collection<PublishTarget> targets = new ArrayList<PublishTarget>();
    private List<ScriptResult> scriptResults = new ArrayList<ScriptResult>();
    private String logServer;
    private String logServerPort;
    private UUID logArchiveId;
    private String topic;
    private String smallImage;
    private String largeImage;

    public PublishEnvironment() {
    }

    public PublishEnvironment(UUID id, UUID solutionId, String name, String description, VersionInfo versionInfo, UUID publishPackageId, int autoTestThreshold, String dueDiligenceConfirmation, String vaUrl, boolean published, PublishEnvironmentType environmentType, boolean allowRepublishToOtherEnvironment, String publishPostScripts, PublishType type, Collection<PublishTarget> targets, List<ScriptResult> scriptResults, String logServer, String logServerPort, UUID logArchiveId, String topic, String smallImage, String largeImage) {
        super(id, solutionId, versionInfo);
        this.name = name;
        this.description = description;
        this.publishPackageId = publishPackageId;
        this.autoTestThreshold = autoTestThreshold;
        this.dueDiligenceConfirmation = dueDiligenceConfirmation;
        this.vaUrl = vaUrl;
        this.published = published;
        this.environmentType = environmentType;
        this.allowRepublishToOtherEnvironment = allowRepublishToOtherEnvironment;
        this.publishPostScripts = publishPostScripts;
        this.type = type;
        if (targets != null) {
            this.targets = targets;
        }
        if (scriptResults != null) {
            this.scriptResults = scriptResults;
        }
        this.logServer = logServer;
        this.logServerPort = logServerPort;
        this.logArchiveId = logArchiveId;
        this.topic = topic;
        this.smallImage = smallImage;
        this.largeImage = largeImage;
    }

    public boolean isAllowRepublishToOtherEnvironment() {
        return this.allowRepublishToOtherEnvironment;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID getPublishPackageId() {
        return this.publishPackageId;
    }

    public int getAutoTestThreshold() {
        return this.autoTestThreshold;
    }

    public String getDueDiligenceConfirmation() {
        return this.dueDiligenceConfirmation;
    }

    public String getVaUrl() {
        return this.vaUrl;
    }

    public boolean isPublished() {
        return this.published;
    }

    public PublishEnvironmentType getEnvironmentType() {
        return this.environmentType;
    }

    public boolean getAllowRepublishToOtherEnvironment() {
        return this.allowRepublishToOtherEnvironment;
    }

    public String getPublishPostScripts() {
        return this.publishPostScripts;
    }

    public PublishType getType() {
        return this.type;
    }

    public Collection<PublishTarget> getTargets() {
        return this.targets;
    }

    public List<ScriptResult> getScriptResults() {
        return this.scriptResults;
    }

    public String getLogServer() {
        return this.logServer;
    }

    public String getLogServerPort() {
        return this.logServerPort;
    }

    public UUID getLogArchiveId() {
        return this.logArchiveId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSmallImage() {
        return this.smallImage;
    }

    public String getLargeImage() {
        return this.largeImage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPublishPackageId(UUID publishPackageId) {
        this.publishPackageId = publishPackageId;
    }

    public void setAutoTestThreshold(int autoTestThreshold) {
        this.autoTestThreshold = autoTestThreshold;
    }

    public void setDueDiligenceConfirmation(String dueDiligenceConfirmation) {
        this.dueDiligenceConfirmation = dueDiligenceConfirmation;
    }

    public void setVaUrl(String vaUrl) {
        this.vaUrl = vaUrl;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public void setEnvironmentType(PublishEnvironmentType environmentType) {
        this.environmentType = environmentType;
    }

    public void setAllowRepublishToOtherEnvironment(boolean allowRepublishToOtherEnvironment) {
        this.allowRepublishToOtherEnvironment = allowRepublishToOtherEnvironment;
    }

    public void setPublishPostScripts(String publishPostScripts) {
        this.publishPostScripts = publishPostScripts;
    }

    public void setType(PublishType type) {
        this.type = type;
    }

    public void setTargets(Collection<PublishTarget> targets) {
        this.targets = targets == null ? new ArrayList() : targets;
    }

    public void setScriptResults(List<ScriptResult> scriptResults) {
        this.scriptResults = scriptResults == null ? new ArrayList() : scriptResults;
    }

    public void setLogServer(String logServer) {
        this.logServer = logServer;
    }

    public void setLogServerPort(String logServerPort) {
        this.logServerPort = logServerPort;
    }

    public void setLogArchiveId(UUID logArchiveId) {
        this.logArchiveId = logArchiveId;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public void setLargeImage(String largeImage) {
        this.largeImage = largeImage;
    }
}

