/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.AutoTestSummary;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface AutoTestsResource {
    public static final String PATH = "auto-tests";
    public static final String POST_BEGIN_PATH = "begin/{solutionId}";
    public static final String POST_BEGIN_SUMMARY = "Starts autotest of the whole solution.";
    public static final String POST_DOCUMENT_BEGIN_PATH = "begin/{solutionId}/{documentId}";
    public static final String POST_DOCUMENT_BEGIN_SUMMARY = "Starts autotest of the specified document.";
    public static final String GET_SUMMARIES_PATH = "summaries/{solutionId}";
    public static final String GET_SUMMARIES_SUMMARY = "Gets all test summaries; test results are not included.";
    public static final String GET_FLOW_SUMMARIES_PATH = "summaries/flow/{solutionId}/{flowId}";
    public static final String GET_FLOW_SUMMARIES_SUMMARY = "Gets all test summaries related to the flow; test results are not included.";
    public static final String GET_SUMMARY_PATH = "summaries/{solutionId}/{summaryId}";
    public static final String GET_SUMMARY_SUMMARY = "Gets the specified test summary.";
    public static final String POST_EXPORT_XLS_BEGIN_PATH = "summaries/export-xls/begin/{solutionId}";
    public static final String POST_EXPORT_XLS_BEGIN_SUMMARY = "Exports the test summaries in xls format.";
    public static final String GET_EXPORT_XLS_RESULT_PATH = "summaries/export-xls/result/{taskId}";
    public static final String GET_EXPORT_XLS_RESULT_SUMMARY = "Gets the result of the xls export task.";

    public UUID beginAutoTest(UUID var1, Map<String, String> var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ResourceException;

    public UUID beginAutoTest(UUID var1, UUID var2, Map<String, String> var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8) throws ResourceException;

    public UUID beginXlsExport(UUID var1) throws ResourceException;

    public InputStream getXlsExport(UUID var1) throws ResourceException;

    public List<AutoTestSummary> getTestSummaries(UUID var1) throws ResourceException;

    public List<AutoTestSummary> getFlowTestSummaries(UUID var1, UUID var2) throws ResourceException;

    public AutoTestSummary getTestSummary(UUID var1, UUID var2, boolean var3, boolean var4, boolean var5) throws ResourceException;
}

