/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.CLUSettings;
import com.artisol.teneo.studio.api.models.Customer;
import com.artisol.teneo.studio.api.models.LLMSettings;
import java.util.List;
import java.util.UUID;

public interface CustomersResource {
    public static final String PATH = "customers";
    public static final String GET_PATH = "";
    public static final String GET_SUMMARY = "Returns the list of customers.";
    public static final String GET_CURRENT_PATH = "current";
    public static final String GET_CURRENT_SUMMARY = "Returns the current selected customer for the user's session.";
    public static final String POST_SWITCH_PATH = "switch/{customerId}";
    public static final String POST_SWITCH_SUMMARY = "Switch the customer in the user's session.";
    public static final String PUT_CLU_SETTINGS_PATH = "settings/clu/{accountId}";
    public static final String PUT_CLU_SETTINGS_SUMMARY = "Set the CLU configuration.";
    public static final String GET_CLU_SETTINGS_PATH = "settings/clu/{accountId}";
    public static final String GET_CLU_SETTINGS_SUMMARY = "Returns the current CLU resource name or null if not configured.";
    public static final String POST_LLM_SETTINGS_PATH = "settings/llm/{accountId}";
    public static final String POST_LLM_SETTINGS_SUMMARY = "Create a LLM settings configuration.";
    public static final String PUT_LLM_SETTINGS_PATH = "settings/llm/{accountId}/{settingsId}";
    public static final String PUT_LLM_SETTINGS_SUMMARY = "Update the specific LLM settings configuration.";
    public static final String DELETE_LLM_SETTINGS_PATH = "settings/llm/{accountId}/{settingsId}";
    public static final String DELETE_LLM_SETTINGS_SUMMARY = "Delete the specific LLM settings configuration.";
    public static final String GET_LLM_SETTINGS_PATH = "settings/llm/{accountId}";
    public static final String GET_LLM_SETTINGS_SUMMARY = "Returns all the LLM settings configurations.";

    public List<Customer> getCustomers() throws ResourceException;

    public Customer getCurrentCustomer() throws ResourceException;

    public void switchCustomer(UUID var1) throws ResourceException;

    public CLUSettings updateCLUSettings(UUID var1, CLUSettings var2) throws ResourceException;

    public CLUSettings getCLUSettings(UUID var1) throws ResourceException;

    public LLMSettings createLLMSettings(UUID var1, LLMSettings var2) throws ResourceException;

    public LLMSettings updateLLMSettings(UUID var1, UUID var2, LLMSettings var3) throws ResourceException;

    public void deleteLLMSettings(UUID var1, UUID var2) throws ResourceException;

    public List<LLMSettings> getLLMSettings(UUID var1) throws ResourceException;
}

