/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.engine.manager.api.models.EngineAnswer;
import com.artisol.teneo.engine.manager.api.models.EngineLogMessage;
import com.artisol.teneo.engine.manager.api.models.EngineStartedSession;
import com.artisol.teneo.engine.manager.api.models.EngineStatus;
import com.artisol.teneo.engine.manager.api.models.EngineStoppedSession;
import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.EngineCondition;
import com.artisol.teneo.studio.api.models.EngineUserInput;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;

public interface EnginesResource {
    public static final String PATH = "engines";
    public static final String GET_ENGINES_PATH = "";
    public static final String GET_ENGINES_SUMMARY = "Gets a list of solution Ids where an engine is running for the current user session.";
    public static final String GET_MESSAGES_PATH = "messages/{solutionId}";
    public static final String GET_MESSAGES_SUMMARY = "Gets the list of engine messages from the solution's current Tryout engine.";
    public static final String GET_STATUS_PATH = "status/{solutionId}";
    public static final String GET_STATUS_SUMMARY = "Gets the status of the solution's current Tryout engine.";
    public static final String POST_SHUTDOWN_PATH = "shutdown/{solutionId}";
    public static final String POST_SHUTDOWN_SUMMARY = "Terminates the solution's current Tryout engine and returns the engine messages.";
    public static final String POST_START_PATH = "start/{solutionId}";
    public static final String POST_START_SUMMARY = "Starts a new Tryout engine in the specified solution.";
    public static final String POST_RELOAD_PATH = "reload/{solutionId}";
    public static final String POST_RELOAD_SUMMARY = "Terminates the solution's current Tryout engine and starts a new one. Returns a list of engine messages for the terminated engine.";
    public static final String POST_SESSION_STOP_PATH = "stop-session/{solutionId}";
    public static final String POST_SESSION_STOP_SUMMARY = "Stops the current session in the solution's Tryout engine.";
    public static final String POST_SESSION_START_PATH = "start-session/{solutionId}";
    public static final String POST_SESSION_START_SUMMARY = "Starts a new session in the solution's Tryout engine.";
    public static final String POST_SESSION_RESTART_PATH = "restart-session/{solutionId}";
    public static final String POST_SESSION_RESTART_SUMMARY = "Stops the current session and starts a new one in the Tryout engine of the solution.";
    public static final String POST_INPUT_FOR_RESPONSE_PATH = "input/{solutionId}";
    public static final String POST_INPUT_FOR_RESPONSE_SUMMARY = "Sends an input to the solution's current Tryout engine and returns the response.";
    public static final String POST_INPUT_FOR_MATCHING_TRIGGERS_PATH = "matching-triggers/{solutionId}";
    public static final String POST_INPUT_FOR_MATCHING_TRIGGERS_SUMMARY = "Sends an input to the solution's current Tryout engine and returns a list of trigger Ids matching the input.";
    public static final String POST_XML_EXPORT_BEGIN_PATH = "xml-export/begin/{solutionId}";
    public static final String POST_XML_EXPORT_BEGIN_SUMMARY = "Starts a task which exports the engine XML of the solution based on the current Tryout session; returns the task Id which can be used to retrieve the XML.";
    public static final String GET_XML_EXPORT_RESULT_PATH = "xml-export/result/{taskId}";
    public static final String GET_XML_EXPORT_RESULT_SUMMARY = "Gets the result of the engine XML export task, if finished.";
    public static final String POST_CONDITION_MATCHING_TRIGGERS_BEGIN_PATH = "condition-matching-triggers/begin/{solutionId}";
    public static final String POST_CONDITION_MATCHING_TRIGGERS_BEGIN_SUMMARY = "Starts a background task which sends a syntax condition to the current Tryout engine to find all triggers matching the syntax; returns the task Id which can be used to retrieve the results.";
    public static final String GET_CONDITION_MATCHING_TRIGGERS_RESULT_PATH = "condition-matching-triggers/result/{taskId}";
    public static final String GET_CONDITION_MATCHING_TRIGGERS_RESULT_SUMMARY = "Gets the result of all triggers matching a syntax condition.";

    public List<UUID> getEngines() throws ResourceException;

    public List<EngineLogMessage> getEngineMessages(UUID var1) throws ResourceException;

    public EngineStatus getEngineStatus(UUID var1) throws ResourceException;

    public List<EngineLogMessage> shutdownEngine(UUID var1) throws ResourceException;

    public void startEngine(UUID var1, boolean var2) throws ResourceException;

    public List<EngineLogMessage> reloadEngine(UUID var1) throws ResourceException;

    public EngineStoppedSession stopEngineSession(UUID var1) throws ResourceException;

    public EngineStartedSession startEngineSession(UUID var1) throws ResourceException;

    public EngineStartedSession restartEngineSession(UUID var1) throws ResourceException;

    public UUID beginXmlExport(UUID var1) throws ResourceException;

    public InputStream getXmlExport(UUID var1) throws ResourceException;

    public EngineAnswer getEngineResponseForInput(UUID var1, EngineUserInput var2) throws ResourceException;

    public List<UUID> getMatchingTriggersForInput(UUID var1, EngineUserInput var2) throws ResourceException;

    public UUID beginTriggerMatchingCondition(UUID var1, EngineCondition var2) throws ResourceException;

    public List<UUID> getTriggerMatchingCondition(UUID var1) throws ResourceException;
}

