/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.FileResource;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;

public interface FileResourcesResource {
    public static final String PATH = "file-resources";
    public static final String GET_FILE_RESOURCES_PATH = "{solutionId}";
    public static final String GET_FILE_RESOURCES_SUMMARY = "Gets a list of the solution's file resources.";
    public static final String GET_FILE_RESOURCE_PATH = "{solutionId}/{fileResourceId}";
    public static final String GET_FILE_RESOURCE_SUMMARY = "Gets a file resource.";
    public static final String GET_FILE_RESOURCE_VERSION_PATH = "{solutionId}/{fileResourceId}/{version}";
    public static final String GET_FILE_RESOURCE_VERSION_SUMMARY = "Gets the specified version of a file resource.";
    public static final String GET_FILE_RESOURCE_CONTENT_PATH = "content/{solutionId}/{fileResourceId}";
    public static final String GET_FILE_RESOURCE_CONTENT_SUMMARY = "Gets a file resource's content.";
    public static final String GET_FILE_RESOURCE_CONTENT_VERSION_PATH = "content/{solutionId}/{fileResourceId}/{version}";
    public static final String GET_FILE_RESOURCE_CONTENT_VERSION_SUMMARY = "Gets the file resource's content of the specified version.";
    public static final String POST_FILE_RESOURCE_PATH = "{solutionId}";
    public static final String POST_FILE_RESOURCE_SUMMARY = "Creates a file resource with content.";
    public static final String PUT_FILE_RESOURCE_PATH = "{solutionId}/{fileResourceId}";
    public static final String PUT_FILE_RESOURCE_SUMMARY = "Updates the specified file resource and/or its content.";
    public static final String DELETE_FILE_RESOURCE_PATH = "{solutionId}/{fileResourceId}";
    public static final String DELETE_FILE_RESOURCE_SUMMARY = "Deletes the specified file resource.";

    public List<FileResource> getFileResources(UUID var1) throws ResourceException;

    public FileResource getFileResource(UUID var1, UUID var2) throws ResourceException;

    public FileResource getFileResourceVersion(UUID var1, UUID var2, String var3) throws ResourceException;

    public InputStream getFileResourceContent(UUID var1, UUID var2) throws ResourceException;

    public InputStream getFileResourceContentVersion(UUID var1, UUID var2, String var3) throws ResourceException;

    public FileResource createFileResource(UUID var1, InputStream var2, FileResource var3) throws ResourceException;

    public FileResource updateFileResource(UUID var1, UUID var2, InputStream var3, FileResource var4) throws ResourceException;

    public void deleteFileResource(UUID var1, UUID var2) throws ResourceException;
}

