/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.Folder;
import com.artisol.teneo.studio.api.models.reports.Report;
import java.util.Collection;
import java.util.UUID;

public interface FoldersResource {
    public static final String PATH = "folders";
    public static final String GET_ROOT_FOLDER_PATH = "{solutionId}";
    public static final String GET_ROOT_FOLDER_SUMMARY = "Gets the root folder.";
    public static final String GET_FOLDER_PATH = "{solutionId}/{folderId}";
    public static final String GET_FOLDER_SUMMARY = "Gets a folder.";
    public static final String GET_FOLDER_VERSION_PATH = "{solutionId}/{folderId}/{version}";
    public static final String GET_FOLDER_VERSION_SUMMARY = "Gets the specified version of the folder.";
    public static final String POST_FOLDER_PATH = "{solutionId}";
    public static final String POST_FOLDER_SUMMARY = "Creates a folder.";
    public static final String PUT_FOLDER_PATH = "{solutionId}/{folderId}";
    public static final String PUT_FOLDER_SUMMARY = "Updates the specified folder.";
    public static final String DELETE_FOLDER_PATH = "{solutionId}/{folderId}";
    public static final String DELETE_FOLDER_SUMMARY = "Deletes the specified folder.";
    public static final String POST_ENABLE_SOLUTION_BEGIN_PATH = "enable/begin/{solutionId}";
    public static final String POST_ENABLE_SOLUTION_BEGIN_SUMMARY = "Starts the enabling of the solution's content.";
    public static final String POST_ENABLE_FOLDER_BEGIN_PATH = "enable/begin/{solutionId}/{folderId}";
    public static final String POST_ENABLE_FOLDER_BEGIN_SUMMARY = "Starts the enabling of the folder's content.";
    public static final String POST_DISABLE_SOLUTION_BEGIN_PATH = "disable/begin/{solutionId}";
    public static final String POST_DISABLE_SOLUTION_BEGIN_SUMMARY = "Starts the disabling of the solution's content.";
    public static final String POST_DISABLE_FOLDER_BEGIN_PATH = "disable/begin/{solutionId}/{folderId}";
    public static final String POST_DISABLE_FOLDER_BEGIN_SUMMARY = "Starts the disabling of the folder's content.";
    public static final String GET_ENABLE_RESULT_PATH = "enable/result/{taskId}";
    public static final String GET_ENABLE_RESULT_SUMMARY = "Gets the result of the enable folder content task.";
    public static final String GET_DISABLE_RESULT_PATH = "disable/result/{taskId}";
    public static final String GET_DISABLE_RESULT_SUMMARY = "Gets the result of the disable folder content task.";
    public static final String POST_INCLUDE_SOLUTION_BEGIN_PATH = "include/begin/{solutionId}";
    public static final String POST_INCLUDE_SOLUTION_BEGIN_SUMMARY = "Starts a task to include the content of the solution.";
    public static final String POST_INCLUDE_FOLDER_BEGIN_PATH = "include/begin/{solutionId}/{folderId}";
    public static final String POST_INCLUDE_FOLDER_BEGIN_SUMMARY = "Starts the inclusion of the folder's content.";
    public static final String POST_EXCLUDE_SOLUTION_BEGIN_PATH = "exclude/begin/{solutionId}";
    public static final String POST_EXCLUDE_SOLUTION_BEGIN_SUMMARY = "Starts the exclusion of the solution's content.";
    public static final String POST_EXCLUDE_FOLDER_BEGIN_PATH = "exclude/begin/{solutionId}/{folderId}";
    public static final String POST_EXCLUDE_FOLDER_BEGIN_SUMMARY = "Starts the exclusion of the folder's content.";
    public static final String GET_INCLUDE_RESULT_PATH = "include/result/{taskId}";
    public static final String GET_INCLUDE_RESULT_SUMMARY = "Gets the result of the include folder content task.";
    public static final String GET_EXCLUDE_RESULT_PATH = "exclude/result/{taskId}";
    public static final String GET_EXCLUDE_RESULT_SUMMARY = "Gets the result of the exclude folder content task.";
    public static final String POST_MOVE_PATH = "move/{solutionId}/{folderId}/{targetFolderId}";
    public static final String POST_MOVE_SUMMARY = "Moves a folder to a target folder.";
    public static final String POST_COPY_BEGIN_PATH = "copy/begin/{solutionId}/{folderId}/{targetSolutionId}/{targetFolderId}";
    public static final String POST_COPY_BEGIN_SUMMARY = "Starts the copy of a folder to a target folder in the same or different solution.";
    public static final String GET_COPY_RESULT_PATH = "copy/result/{taskId}";
    public static final String GET_COPY_RESULT_SUMMARY = "Gets the result of the copy folder task.";
    public static final String POST_RENAME_FOLDER_PATH = "rename/{solutionId}/{folderId}";
    public static final String POST_RENAME_FOLDER_SUMMARY = "Renames the folder's name.";

    public Folder getFolder(UUID var1) throws ResourceException;

    public Folder getFolder(UUID var1, UUID var2) throws ResourceException;

    public Folder getFolderVersion(UUID var1, UUID var2, String var3) throws ResourceException;

    public Folder createFolder(UUID var1, Folder var2) throws ResourceException;

    public Folder updateFolder(UUID var1, UUID var2, Folder var3) throws ResourceException;

    public void deleteFolder(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public UUID beginEnable(UUID var1, boolean var2) throws ResourceException;

    public UUID beginEnable(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public UUID beginDisable(UUID var1, boolean var2) throws ResourceException;

    public UUID beginDisable(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public UUID beginInclude(UUID var1, boolean var2) throws ResourceException;

    public UUID beginInclude(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public UUID beginExclude(UUID var1) throws ResourceException;

    public UUID beginExclude(UUID var1, UUID var2) throws ResourceException;

    public Collection<Report> getIncludeResult(UUID var1) throws ResourceException;

    public Collection<Report> getExcludeResult(UUID var1) throws ResourceException;

    public Collection<Report> getEnableResult(UUID var1) throws ResourceException;

    public Collection<Report> getDisableResult(UUID var1) throws ResourceException;

    public void move(UUID var1, UUID var2, UUID var3) throws ResourceException;

    public UUID beginCopy(UUID var1, UUID var2, UUID var3, UUID var4) throws ResourceException;

    public Collection<Report> getCopyResult(UUID var1) throws ResourceException;

    public void rename(UUID var1, UUID var2, String var3) throws ResourceException;
}

