/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.GlobalScript;
import com.artisol.teneo.studio.api.models.GlobalScriptOrdering;
import java.util.List;
import java.util.UUID;

public interface GlobalScriptsResource {
    public static final String PATH = "global-scripts";
    public static final String GET_SCRIPTS_PATH = "{solutionId}";
    public static final String GET_SCRIPTS_SUMMARY = "Gets a list of the solution's global scripts.";
    public static final String GET_SCRIPT_PATH = "{solutionId}/{globalScriptId}";
    public static final String GET_SCRIPT_SUMMARY = "Gets a global script.";
    public static final String GET_SCRIPT_VERSION_PATH = "{solutionId}/{globalScriptId}/{version}";
    public static final String GET_SCRIPT_VERSION_SUMMARY = "Gets the specified version of the global script.";
    public static final String POST_SCRIPT_PATH = "{solutionId}";
    public static final String POST_SCRIPT_SUMMARY = "Creates a global script.";
    public static final String PUT_SCRIPT_PATH = "{solutionId}/{globalScriptId}";
    public static final String PUT_SCRIPT_SUMMARY = "Updates the specified global script.";
    public static final String DELETE_SCRIPT_PATH = "{solutionId}/{globalScriptId}";
    public static final String DELETE_SCRIPT_SUMMARY = "Deletes the specified global script.";
    public static final String GET_ORDERING_PATH = "ordering/{solutionId}";
    public static final String GET_ORDERING_SUMMARY = "Gets the global script ordering.";
    public static final String GET_ORDERING_VERSION_PATH = "ordering/{solutionId}/{version}";
    public static final String GET_ORDERING_VERSION_SUMMARY = "Gets the specified version of the global script ordering.";
    public static final String PUT_ORDERING_PATH = "ordering/{solutionId}";
    public static final String PUT_ORDERING_SUMMARY = "Updates the global script ordering.";

    public List<GlobalScript> getScripts(UUID var1) throws ResourceException;

    public GlobalScript getScript(UUID var1, UUID var2) throws ResourceException;

    public GlobalScript getScriptVersion(UUID var1, UUID var2, String var3) throws ResourceException;

    public GlobalScript createScript(UUID var1, GlobalScript var2) throws ResourceException;

    public GlobalScript updateScript(UUID var1, UUID var2, GlobalScript var3) throws ResourceException;

    public void deleteScript(UUID var1, UUID var2) throws ResourceException;

    public GlobalScriptOrdering getOrdering(UUID var1) throws ResourceException;

    public GlobalScriptOrdering getOrderingVersion(UUID var1, String var2) throws ResourceException;

    public GlobalScriptOrdering updateOrdering(UUID var1, GlobalScriptOrdering var2) throws ResourceException;
}

