/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.Entity;
import com.artisol.teneo.studio.api.models.LanguageObject;
import com.artisol.teneo.studio.api.models.Library;
import com.artisol.teneo.studio.api.models.LibraryAssignment;
import com.artisol.teneo.studio.api.models.LibraryFolder;
import com.artisol.teneo.studio.api.models.SolutionLibraries;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;

public interface LibrariesResource {
    public static final String PATH = "libraries";
    public static final String GET_LIBRARIES_PATH = "";
    public static final String GET_LIBRARY_PATH = "{libraryId}/{libraryVersion}";
    public static final String POST_IMPORT_LIBRARY_BEGIN_PATH = "begin";
    public static final String POST_EXPORT_LIBRARY_BEGIN_PATH = "export/begin/{solutionId}";
    public static final String GET_EXPORT_RESULT_PATH = "export/result/{taskId}";
    public static final String DELETE_LIBRARY_PATH = "{libraryId}/{libraryVersion}";
    public static final String GET_ROOT_FOLDER_PATH = "folder/{libraryId}/{libraryVersion}";
    public static final String GET_ROOT_FOLDER_SUMMARY = "Gets the root folder of the specified library.";
    public static final String GET_FOLDER_PATH = "folder/{libraryId}/{libraryVersion}/{folderId}";
    public static final String GET_FOLDER_SUMMARY = "Gets the specified folder from the specified library.";
    public static final String GET_ENTITY_PATH = "entity/{libraryId}/{libraryVersion}/{entityId}";
    public static final String GET_ENTITY_SUMMARY = "Gets the entity from the library.";
    public static final String GET_LANGUAGE_OBJECT_PATH = "language-object/{libraryId}/{libraryVersion}/{languageObjectId}";
    public static final String GET_LANGUAGE_OBJECT_SUMMARY = "Gets the language object from the library.";
    public static final String GET_ASSIGNMENTS_PATH = "assignments/{libraryId}/{libraryVersion}";
    public static final String GET_SOLUTION_LIBRARIES_PATH = "solution/{solutionId}";
    public static final String GET_SOLUTION_LIBRARIES_VERSION_PATH = "solution/{solutionId}/{version}";
    public static final String PUT_SOLUTION_LIBRARIES_PATH = "solution/{solutionId}";

    public List<Library> getLibraries(String var1) throws ResourceException;

    public Library getLibrary(UUID var1, String var2) throws ResourceException;

    public UUID beginImportLibrary(InputStream var1) throws ResourceException;

    public UUID beginExportLibrary(UUID var1, String var2) throws ResourceException;

    public InputStream getExportLibraryResult(UUID var1) throws ResourceException;

    public void deleteLibrary(UUID var1, String var2) throws ResourceException;

    public LibraryFolder getFolder(UUID var1, String var2) throws ResourceException;

    public LibraryFolder getFolder(UUID var1, String var2, UUID var3) throws ResourceException;

    public Entity getEntity(UUID var1, String var2, UUID var3) throws ResourceException;

    public LanguageObject getLanguageObject(UUID var1, String var2, UUID var3) throws ResourceException;

    public List<LibraryAssignment> getAssignments(UUID var1, String var2) throws ResourceException;

    public SolutionLibraries getSolutionLibraries(UUID var1) throws ResourceException;

    public SolutionLibraries getSolutionLibrariesVersion(UUID var1, String var2) throws ResourceException;

    public SolutionLibraries updateSolutionLibraries(UUID var1, SolutionLibraries var2) throws ResourceException;
}

