/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.inquire.api.models.Adorner;
import com.artisol.teneo.inquire.api.models.Aggregator;
import com.artisol.teneo.inquire.api.models.AggregatorBucketInfo;
import com.artisol.teneo.inquire.api.models.AugmenterAction;
import com.artisol.teneo.inquire.api.models.AugmenterImportResult;
import com.artisol.teneo.inquire.api.models.AugmentersOverview;
import com.artisol.teneo.inquire.api.models.GroovyAdornerTestResult;
import com.artisol.teneo.inquire.api.models.GroovyAggregatorTestResult;
import com.artisol.teneo.inquire.api.models.LogDataSourceErrors;
import com.artisol.teneo.inquire.api.models.LogDataSourceStatus;
import com.artisol.teneo.inquire.api.models.LogDataSourceWeeks;
import com.artisol.teneo.inquire.api.models.SavedResult;
import com.artisol.teneo.inquire.api.models.TqlAdornerTestResult;
import com.artisol.teneo.inquire.api.models.TqlAggregatorTestResult;
import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.LogDataSource;
import com.artisol.teneo.studio.api.models.LogDataSourceAccessRoles;
import com.artisol.teneo.studio.api.models.Overview;
import com.artisol.teneo.studio.api.models.VersionInfo;
import java.io.InputStream;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;

public interface LogDataSourcesResource {
    public static final String PATH = "log-data-sources";
    public static final String GET_LOG_DATA_SOURCES_PATH = "";
    public static final String GET_LOG_DATA_SOURCES_SUMMARY = "Gets the list of Log Data Sources.";
    public static final String GET_LOG_DATA_SOURCES_FOR_SOLUTION_PATH = "{solutionId}";
    public static final String GET_LOG_DATA_SOURCES_FOR_SOLUTION_SUMMARY = "Gets a list of Log Data Sources in the specified solution.";
    public static final String POST_LINK_LOG_DATA_SOURCE_PATH = "link/{solutionId}/{logDataSourceId}";
    public static final String POST_LINK_LOG_DATA_SOURCE_SUMMARY = "Links the Log Data Source to the specified solution.";
    public static final String POST_UNLINK_LOG_DATA_SOURCE_PATH = "unlink/{solutionId}/{logDataSourceId}";
    public static final String POST_UNLINK_LOG_DATA_SOURCE_SUMMARY = "Unlinks a Log Data Source from a specific solution.";
    public static final String POST_SHARED_QUERY_LOCK_PATH = "shared-queries/lock/{logDataSourceId}/{sharedQueryId}";
    public static final String POST_SHARED_QUERY_LOCK_SUMMARY = "Locks the shared query defined by its sharedQueryId and returns a lockToken.";
    public static final String GET_SHARED_QUERY_HISTORY_PATH = "shared-queries/history/{logDataSourceId}/{sharedQueryId}";
    public static final String GET_SHARED_QUERY_HISTORY_SUMMARY = "Gets the history of a shared query.";
    public static final String POST_SHARED_QUERY_RESTORE_PATH = "shared-queries/restore/{logDataSourceId}/{sharedQueryId}/{version}";
    public static final String POST_SHARED_QUERY_RESTORE_SUMMARY = "Restores a version of a shared query.";
    public static final String POST_AUGMENTERS_IMPORT_BEGIN_PATH = "augmenters/import/begin/{logDataSourceId}";
    public static final String POST_AUGMENTERS_IMPORT_BEGIN_SUMMARY = "Starts a task to import augmenters contained in a zip file.";
    public static final String GET_AUGMENTERS_IMPORT_RESULT_PATH = "augmenters/import/result/{taskId}";
    public static final String GET_AUGMENTERS_IMPORT_RESULT_SUMMARY = "Gets the result of the augmenters import task.";
    public static final String GET_AUGMENTERS_EXPORT_PATH = "augmenters/export/{logDataSourceId}";
    public static final String GET_AUGMENTERS_EXPORT_SUMMARY = "Exports all augmenters in a zip file.";
    public static final String GET_AUGMENTERS_OVERVIEW_PATH = "augmenters/overview/{logDataSourceId}";
    public static final String GET_AUGMENTERS_OVERVIEW_SUMMARY = "Gets data overview.";
    public static final String POST_ADORNER_TEST_TQL_PATH = "adorners/test/tql/{logDataSourceId}";
    public static final String POST_ADORNER_TEST_TQL_SUMMARY = "Tests a TQL adorner.";
    public static final String POST_ADORNER_TEST_GROOVY_PATH = "adorners/test/groovy/{logDataSourceId}";
    public static final String POST_ADORNER_TEST_GROOVY_SUMMARY = "Tests a Groovy adorner.";
    public static final String POST_ADORNER_PATH = "adorners/{logDataSourceId}";
    public static final String POST_ADORNER_SUMMARY = "Creates an action to add a new adorner.";
    public static final String PUT_ADORNER_PATH = "adorners/{logDataSourceId}/{adornerId}";
    public static final String PUT_ADORNER_SUMMARY = "Creates an action to update the specified adorner.";
    public static final String GET_ADORNER_PATH = "adorners/{logDataSourceId}/{adornerId}";
    public static final String GET_ADORNER_SUMMARY = "Gets the specified adorner.";
    public static final String GET_ADORNERS_PATH = "adorners/{logDataSourceId}";
    public static final String GET_ADORNERS_SUMMARY = "Gets all adorners.";
    public static final String POST_ADORNER_ENABLE_PATH = "adorners/enable/{logDataSourceId}/{adornerId}";
    public static final String POST_ADORNER_ENABLE_SUMMARY = "Creates an action to enable the specified adorner.";
    public static final String POST_ADORNER_DISABLE_PATH = "adorners/disable/{logDataSourceId}/{adornerId}";
    public static final String POST_ADORNER_DISABLE_SUMMARY = "Creates an action to disable the specified adorner.";
    public static final String DELETE_ADORNER_PATH = "adorners/{logDataSourceId}/{adornerId}";
    public static final String DELETE_ADORNER_SUMMARY = "Deletes the specified adorner.";
    public static final String GET_AGGREGATOR_BUCKETS_PATH = "aggregators/buckets/{logDataSourceId}";
    public static final String GET_AGGREGATOR_BUCKETS_SUMMARY = "Lists aggregator buckets.";
    public static final String POST_AGGREGATOR_TEST_TQL_PATH = "aggregators/test/tql/{logDataSourceId}";
    public static final String POST_AGGREGATOR_TEST_TQL_SUMMARY = "Tests a TQL aggregator.";
    public static final String POST_AGGREGATOR_TEST_GROOVY_PATH = "aggregators/test/groovy/{logDataSourceId}";
    public static final String POST_AGGREGATOR_TEST_GROOVY_SUMMARY = "Tests a Groovy aggregator.";
    public static final String POST_AGGREGATOR_PATH = "aggregators/{logDataSourceId}";
    public static final String POST_AGGREGATOR_SUMMARY = "Creates an action to add a new aggregator.";
    public static final String PUT_AGGREGATOR_PATH = "aggregators/{logDataSourceId}/{aggregatorId}";
    public static final String PUT_AGGREGATOR_SUMMARY = "Creates an action to update the specified aggregator.";
    public static final String GET_AGGREGATOR_PATH = "aggregators/{logDataSourceId}/{aggregatorId}";
    public static final String GET_AGGREGATOR_SUMMARY = "Gets the specified aggregator.";
    public static final String GET_AGGREGATORS_PATH = "aggregators/{logDataSourceId}";
    public static final String GET_AGGREGATORS_SUMMARY = "Gets all aggregators.";
    public static final String POST_AGGREGATOR_ENABLE_PATH = "aggregators/enable/{logDataSourceId}/{aggregatorId}";
    public static final String POST_AGGREGATOR_ENABLE_SUMMARY = "Creates an action to enable the specified aggregator.";
    public static final String POST_AGGREGATOR_DISABLE_PATH = "aggregators/disable/{logDataSourceId}/{aggregatorId}";
    public static final String POST_AGGREGATOR_DISABLE_SUMMARY = "Creates an action to disable the specified aggregator.";
    public static final String DELETE_AGGREGATOR_PATH = "aggregators/{logDataSourceId}/{aggregatorId}";
    public static final String DELETE_AGGREGATOR_SUMMARY = "Deletes the specified aggregator.";
    public static final String POST_ACTION_PATH = "actions/{logDataSourceId}";
    public static final String POST_ACTION_SUMMARY = "Creates an action.";
    public static final String PUT_ACTION_PATH = "actions/{logDataSourceId}/{actionId}";
    public static final String PUT_ACTION_SUMMARY = "Updates the specified action.";
    public static final String GET_ACTION_PATH = "actions/{logDataSourceId}/{actionId}";
    public static final String GET_ACTION_SUMMARY = "Gets the specified action.";
    public static final String GET_ACTIONS_PATH = "actions/{logDataSourceId}";
    public static final String GET_ACTIONS_SUMMARY = "Gets all actions.";
    public static final String DELETE_ACTION_PATH = "actions/{logDataSourceId}/{actionId}";
    public static final String DELETE_ACTION_SUMMARY = "Deletes the specified waiting action.";
    public static final String DELETE_ACTIONS_PATH = "actions/{logDataSourceId}";
    public static final String DELETE_ACTIONS_SUMMARY = "Deletes all waiting actions.";
    public static final String POST_ACTION_PERFORM_PATH = "actions/perform/{logDataSourceId}/{actionId}";
    public static final String POST_ACTION_PERFORM_SUMMARY = "Performs execution of the specified waiting augmenter action.";
    public static final String POST_ACTIONS_PERFORM_PATH = "actions/perform/{logDataSourceId}";
    public static final String POST_ACTIONS_PERFORM_SUMMARY = "Performs execution of all waiting augmenter actions.";
    public static final String GET_SAVED_RESULTS_PATH = "saved-results/{logDataSourceId}";
    public static final String GET_SAVED_RESULTS_SUMMARY = "Lists all saved results for the Log Data Source.";
    public static final String POST_SAVED_RESULT_PATH = "saved-results/{logDataSourceId}";
    public static final String POST_SAVED_RESULT_SUMMARY = "Creates a saved result in the specified Log Data Source.";
    public static final String PUT_SAVED_RESULT_PATH = "saved-results/{logDataSourceId}/{savedResultId}";
    public static final String PUT_SAVED_RESULT_SUMMARY = "Updates the specified saved results in the Log Data Source.";
    public static final String DELETE_SAVED_RESULT_PATH = "saved-results/{logDataSourceId}/{savedResultId}";
    public static final String DELETE_SAVED_RESULT_SUMMARY = "Deletes the specified saved result from the Log Data Source.";
    public static final String GET_EXPORT_SAVED_RESULT_PATH = "saved-results/export/{logDataSourceId}/{savedResultId}";
    public static final String GET_EXPORT_SAVED_RESULT_SUMMARY = "Exports the saved result from the Log Data Source to the specified format ('json' or 'csv').";
    public static final String GET_EXPORT_SAVED_RESULTS_PACKAGE_PATH = "saved-results/export-package/{logDataSourceId}";
    public static final String GET_EXPORT_SAVED_RESULTS_PACKAGE_SUMMARY = "Exports all saved results in json from the Log Data Source, packaged in a zip file.";
    public static final String POST_SYNCHRONIZATION_BEGIN_PATH = "synchronization/begin/{logDataSourceId}";
    public static final String POST_SYNCHRONIZATION_BEGIN_SUMMARY = "Starts the Log Data Source synchronization task in Inquire and polls the status.";
    public static final String POST_CANCEL_SYNCHRONIZATION_PATH = "synchronization/cancel/{logDataSourceId}";
    public static final String POST_CANCEL_SYNCHRONIZATION_SUMMARY = "Cancels the Log Data Source synchronization.";
    public static final String GET_LOG_DATA_SOURCE_ERRORS_PATH = "errors/{logDataSourceId}";
    public static final String GET_LOG_DATA_SOURCE_ERRORS_SUMMARY = "Gets the synchronization errors for the Log Data Source.";
    public static final String DELETE_LOG_DATA_SOURCE_ERRORS_PATH = "errors/{logDataSourceId}";
    public static final String DELETE_LOG_DATA_SOURCE_ERRORS_SUMMARY = "Deletes the synchronization errors of the Log Data Source.";
    public static final String POST_CLEAR_LOG_DATA_SOURCE_PATH = "clear/{logDataSourceId}";
    public static final String POST_CLEAR_LOG_DATA_SOURCE_SUMMARY = "Deletes the content of the specified Log Data Source.";
    public static final String GET_LOG_DATA_SOURCE_STATUS_PATH = "status/{logDataSourceId}";
    public static final String GET_LOG_DATA_SOURCE_STATUS_SUMMARY = "Gets the current status of the Log Data Source.";
    public static final String POST_OVERVIEW_BEGIN_PATH = "overview/begin/{logDataSourceId}";
    public static final String POST_OVERVIEW_BEGIN_SUMMARY = "Starts task to obtain the overview of the Log Data Source.";
    public static final String GET_OVERVIEW_RESULT_PATH = "overview/result/{taskId}";
    public static final String GET_OVERVIEW_RESULT_SUMMARY = "Gets the result of the data overview task.";
    public static final String GET_ACCESS_ROLES_PATH = "access-roles/{logDataSourceId}";
    public static final String GET_ACCESS_ROLES_SUMMARY = "Gets current user's access roles for the specified Log Data Source.";
    public static final String GET_WEEKS_PATH = "weeks/{logDataSourceId}";
    public static final String GET_WEEKS_SUMMARY = "Gets the weeks of the Log Data Source.";
    public static final String GET_REVISIONS_PATH = "revisions/{logDataSourceId}";
    public static final String GET_REVISIONS_SUMMARY = "Gets all solution revisions.";

    public String lock(UUID var1, UUID var2) throws ResourceException;

    public List<VersionInfo> getHistory(UUID var1, UUID var2) throws ResourceException;

    public void restore(UUID var1, UUID var2, String var3) throws ResourceException;

    public void beginSynchronization(UUID var1) throws ResourceException;

    public void cancelSynchronization(UUID var1) throws ResourceException;

    public LogDataSourceErrors getLogDataSourceErrors(UUID var1) throws ResourceException;

    public void clearLogDataSource(UUID var1) throws ResourceException;

    public LogDataSourceStatus getLogDataSourceStatus(UUID var1) throws ResourceException;

    public TqlAdornerTestResult testTqlAdorner(UUID var1, Adorner var2) throws ResourceException;

    public GroovyAdornerTestResult testGroovyAdorner(UUID var1, Adorner var2) throws ResourceException;

    public TqlAggregatorTestResult testTqlAggregator(UUID var1, Aggregator var2) throws ResourceException;

    public GroovyAggregatorTestResult testGroovyAggregator(UUID var1, Aggregator var2) throws ResourceException;

    public String createAdorner(UUID var1, Adorner var2) throws ResourceException;

    public String updateAdorner(UUID var1, String var2, Adorner var3) throws ResourceException;

    public String createAggregator(UUID var1, Aggregator var2) throws ResourceException;

    public String updateAggregator(UUID var1, String var2, Aggregator var3) throws ResourceException;

    public Adorner getAdorner(UUID var1, String var2) throws ResourceException;

    public Aggregator getAggregator(UUID var1, String var2) throws ResourceException;

    public List<Adorner> getAdorners(UUID var1) throws ResourceException;

    public List<Aggregator> getAggregators(UUID var1) throws ResourceException;

    public String enableAdorner(UUID var1, String var2) throws ResourceException;

    public String disableAdorner(UUID var1, String var2) throws ResourceException;

    public String enableAggregator(UUID var1, String var2) throws ResourceException;

    public String disableAggregator(UUID var1, String var2) throws ResourceException;

    public String deleteAdorner(UUID var1, String var2) throws ResourceException;

    public String deleteAggregator(UUID var1, String var2) throws ResourceException;

    public AugmenterAction createAction(UUID var1, AugmenterAction var2) throws ResourceException;

    public AugmenterAction updateAction(UUID var1, String var2, AugmenterAction var3) throws ResourceException;

    public AugmenterAction getAction(UUID var1, String var2) throws ResourceException;

    public List<AugmenterAction> getActions(UUID var1) throws ResourceException;

    public void deleteAction(UUID var1, String var2) throws ResourceException;

    public void deleteActions(UUID var1) throws ResourceException;

    public List<String> performAction(UUID var1, String var2) throws ResourceException;

    public List<String> performActions(UUID var1) throws ResourceException;

    public UUID beginImportAugmenters(UUID var1, InputStream var2) throws ResourceException;

    public List<AugmenterImportResult> getImportAugmentersResult(UUID var1) throws ResourceException;

    public InputStream exportAugmenters(UUID var1) throws ResourceException;

    public AugmentersOverview getAugmentersOverview(UUID var1) throws ResourceException;

    public SortedSet<Long> getSolutionRevisions(UUID var1) throws ResourceException;

    public List<AggregatorBucketInfo> listAggregatorBuckets(UUID var1) throws ResourceException;

    public UUID beginOverview(UUID var1) throws ResourceException;

    public Overview getOverview(UUID var1) throws ResourceException;

    public List<LogDataSource> getLogDataSources() throws ResourceException;

    public List<LogDataSource> getLogDataSourcesForSolution(UUID var1) throws ResourceException;

    public void linkLogDataSourceToSolution(UUID var1, UUID var2) throws ResourceException;

    public void unlinkLogDataSourceFromSolution(UUID var1, UUID var2) throws ResourceException;

    public LogDataSourceAccessRoles getAccessRoles(UUID var1) throws ResourceException;

    public LogDataSourceWeeks getLogDataSourceWeeks(UUID var1) throws ResourceException;

    public List<SavedResult> getSavedResults(UUID var1) throws ResourceException;

    public SavedResult createSavedResult(UUID var1, SavedResult var2, InputStream var3) throws ResourceException;

    public SavedResult updateSavedResult(UUID var1, String var2, SavedResult var3, InputStream var4) throws ResourceException;

    public void deleteSavedResult(UUID var1, String var2) throws ResourceException;

    public InputStream exportSavedResult(UUID var1, String var2, String var3) throws ResourceException;

    public InputStream exportSavedResultsPackage(UUID var1, List<String> var2) throws ResourceException;

    public void clearLogDataSourceErrors(UUID var1) throws ResourceException;
}

