/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.headers.ChangeDocumentHeader;
import com.artisol.teneo.studio.api.models.reports.Report;
import java.util.List;
import java.util.UUID;

public interface MasterLocalResource {
    public static final String PATH = "master-local";
    public static final String GET_MASTER_CHANGES_PATH = "changes/{solutionId}/{documentId}";
    public static final String GET_MASTER_CHANGES_SUMMARY = "Gets the list of changes made to the master solution that can be applied to the specified local solution for the specified document.";
    public static final String POST_MASTER_CHANGES_BEGIN_PATH = "changes/begin/{solutionId}";
    public static final String POST_MASTER_CHANGES_BEGIN_SUMMARY = "Starts an asynchronous task to collect the changes made to the master solution that can be applied to the specified local solution.";
    public static final String GET_MASTER_CHANGES_RESULT_PATH = "changes/result/{taskId}";
    public static final String GET_MASTER_CHANGES_RESULT_SUMMARY = "Gets the list of changes made to a master solution collected by the specified task.";
    public static final String POST_UPDATE_BEGIN_PATH = "update/begin/{solutionId}";
    public static final String POST_UPDATE_BEGIN_SUMMARY = "Starts an asynchronous task to update the specified local solution with changes made to its master solution.";
    public static final String GET_UPDATE_RESULT_PATH = "update/result/{taskId}";
    public static final String GET_UPDATE_RESULT_SUMMARY = "Gets the list of Report objects for the specified master-local update task.";
    public static final String POST_RESET_LOCAL_PATH = "reset/{solutionId}/{documentId}";
    public static final String POST_RESET_LOCAL_SUMMARY = "Resets the specified local solution document to its state in the master solution.";

    public List<ChangeDocumentHeader> getMasterChanges(UUID var1, UUID var2) throws ResourceException;

    public UUID beginGetMasterChanges(UUID var1) throws ResourceException;

    public List<ChangeDocumentHeader> getGetMasterChangesResult(UUID var1) throws ResourceException;

    public UUID beginUpdateLocalSolution(UUID var1, List<String> var2) throws ResourceException;

    public List<Report> getUpdateLocalSolutionResult(UUID var1) throws ResourceException;

    public void resetLocalDocumentToMasterState(UUID var1, UUID var2) throws ResourceException;
}

