/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.enums.PublishEnvironmentType;
import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.publish.PublishEnvironment;
import com.artisol.teneo.studio.api.models.publish.PublishEnvironmentVersionInfo;
import com.artisol.teneo.studio.api.models.publish.PublishOption;
import com.artisol.teneo.studio.api.models.publish.PublishTarget;
import com.artisol.teneo.studio.api.models.publish.PublishTargetStatus;
import com.artisol.teneo.studio.api.models.reports.Report;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public interface PublishEnvironmentsResource {
    public static final String PATH = "publish-environments";
    public static final String POST_PUBLISH_BEGIN_PATH = "publish/begin/{solutionId}/{environmentId}";
    public static final String POST_PUBLISH_BEGIN_SUMMARY = "Starts publishing the solution.";
    public static final String POST_UNPUBLISH_BEGIN_PATH = "unpublish/begin/{solutionId}/{environmentId}";
    public static final String POST_UNPUBLISH_BEGIN_SUMMARY = "Starts unpublishing the solution.";
    public static final String POST_ENVIRONMENT_PATH = "{solutionId}";
    public static final String POST_ENVIRONMENT_SUMMARY = "Creates a publish environment.";
    public static final String PUT_ENVIRONMENT_PATH = "{solutionId}/{environmentId}";
    public static final String PUT_ENVIRONMENT_SUMMARY = "Updates the specified publish environment.";
    public static final String GET_PUBLISHED_URL_PATH = "published-url/{solutionId}/{environmentId}";
    public static final String GET_PUBLISHED_URL_SUMMARY = "Gets the published solution's URL.";
    public static final String GET_ENVIRONMENT_PATH = "{solutionId}/{environmentId}";
    public static final String GET_ENVIRONMENT_SUMMARY = "Gets the specified publish environment.";
    public static final String GET_ENVIRONMENTS_PATH = "{solutionId}";
    public static final String GET_ENVIRONMENTS_SUMMARY = "Gets all publish environments in the specified solution.";
    public static final String DELETE_ENVIRONMENT_PATH = "{solutionId}/{environmentId}";
    public static final String DELETE_ENVIRONMENT_SUMMARY = "Deletes the specified publish environment.";
    public static final String POST_PRE_CONFIGURED_PATH = "pre-configured/{solutionId}/{type}";
    public static final String POST_PRE_CONFIGURED_SUMMARY = "Creates the preconfigured publish environment.";
    public static final String POST_TARGET_PATH = "targets/{solutionId}/{environmentId}";
    public static final String POST_TARGET_SUMMARY = "Creates a publish target and adds it to the publish environment; the data model's admin password is not shown in the response.";
    public static final String PUT_TARGET_PATH = "targets/{solutionId}/{targetId}";
    public static final String PUT_TARGET_SUMMARY = "Updates a publish target. In the request, if the data model's admin password is empty, it will not be changed; the data model's admin password is not shown in the response.";
    public static final String DELETE_TARGET_PATH = "targets/{solutionId}/{targetId}";
    public static final String DELETE_TARGET_SUMMARY = "Deletes the specified publish target.";
    public static final String GET_TARGET_PATH = "targets/{solutionId}/{targetId}";
    public static final String GET_TARGET_SUMMARY = "Gets the publish target; the data model's admin password is not shown in the response.";
    public static final String POST_STATUS_UPDATE_BEGIN_PATH = "status/update/begin/{solutionId}/{environmentId}";
    public static final String POST_STATUS_UPDATE_BEGIN_SUMMARY = "Starts a task to update the status of the publish environment's targets.";
    public static final String GET_STATUSES_PATH = "status/{solutionId}";
    public static final String GET_STATUSES_SUMMARY = "Gets the status of all publish targets.";
    public static final String GET_TARGET_STATUS_PATH = "status/{solutionId}/{targetId}";
    public static final String GET_TARGET_STATUS_SUMMARY = "Gets the status of the specified publish target.";
    public static final String GET_ENVIRONMENT_HISTORY_PATH = "history/{solutionId}/{environmentId}";
    public static final String GET_ENVIRONMENT_HISTORY_SUMMARY = "Gets the version history of a publish environment.";
    public static final String GET_WEBAPP_PUBLISH_RESULT_PATH = "publish/webapp/result/{taskId}";
    public static final String GET_WEBAPP_PUBLISH_RESULT_SUMMARY = "Gets the result of the web app publishing task.";
    public static final String GET_WEBAPP_UNPUBLISH_RESULT_PATH = "unpublish/webapp/result/{taskId}";
    public static final String GET_WEBAPP_UNPUBLISH_RESULT_SUMMARY = "Gets the result of the web app unpublish task.";
    public static final String GET_FILE_PUBLISH_RESULT_PATH = "publish/file/result/{taskId}";
    public static final String GET_FILE_PUBLISH_RESULT_SUMMARY = "Gets the result of the file publishing task.";
    public static final String GET_STATUS_UPDATE_RESULT_PATH = "status/update/result/{taskId}";
    public static final String GET_STATUS_UPDATE_RESULT_SUMMARY = "Gets the result of the publish environment status update task.";

    public UUID beginPublish(UUID var1, UUID var2, PublishOption var3) throws ResourceException;

    public UUID beginUnpublish(UUID var1, UUID var2) throws ResourceException;

    public PublishEnvironment createPublishEnvironment(UUID var1, PublishEnvironment var2) throws ResourceException;

    public PublishEnvironment updatePublishEnvironment(UUID var1, UUID var2, PublishEnvironment var3) throws ResourceException;

    public PublishTarget createPublishEnvironmentTarget(UUID var1, UUID var2, PublishTarget var3) throws ResourceException;

    public PublishTarget updatePublishEnvironmentTarget(UUID var1, UUID var2, PublishTarget var3) throws ResourceException;

    public void deletePublishEnvironment(UUID var1, UUID var2) throws ResourceException;

    public void deletePublishEnvironmentTarget(UUID var1, UUID var2) throws ResourceException;

    public String getPublishUrl(UUID var1, UUID var2) throws ResourceException;

    public UUID beginUpdatePublishEnvironmentStatus(UUID var1, UUID var2) throws ResourceException;

    public Collection<PublishTargetStatus> getPublishEnvironmentStatusForSolution(UUID var1) throws ResourceException;

    public List<PublishEnvironment> getPublishEnvironments(UUID var1) throws ResourceException;

    public PublishEnvironment createPreConfiguredPublishEnvironment(UUID var1, PublishEnvironmentType var2) throws ResourceException;

    public PublishEnvironment getPublishEnvironment(UUID var1, UUID var2) throws ResourceException;

    public PublishTarget getPublishEnvironmentTarget(UUID var1, UUID var2) throws ResourceException;

    public PublishTargetStatus getPublishEnvironmentTargetStatus(UUID var1, UUID var2) throws ResourceException;

    public Collection<PublishEnvironmentVersionInfo> getHistory(UUID var1, UUID var2) throws ResourceException;

    public Collection<Report> getWebappPublishResult(UUID var1) throws ResourceException;

    public Collection<Report> getWebappUnpublishResult(UUID var1) throws ResourceException;

    public InputStream getFilePublishResult(UUID var1) throws ResourceException;

    public Collection<Report> getPublishEnvironmentStatusUpdateResult(UUID var1) throws ResourceException;
}

