/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.Solution;
import com.artisol.teneo.studio.api.models.SolutionProperties;
import com.artisol.teneo.studio.api.models.SolutionStatistics;
import com.artisol.teneo.studio.api.models.User;
import com.artisol.teneo.studio.api.models.reports.Report;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public interface SolutionsResource {
    public static final String PATH = "solutions";
    public static final String GET_SOLUTIONS_PATH = "";
    public static final String GET_SOLUTIONS_SUMMARY = "Gets a list of the solutions.";
    public static final String GET_SOLUTION_PATH = "{solutionId}";
    public static final String GET_SOLUTION_SUMMARY = "Gets the specified solution.";
    public static final String POST_SOLUTION_PATH = "begin";
    public static final String POST_SOLUTION_SUMMARY = "Starts the creation of a solution.";
    public static final String PUT_SOLUTION_PATH = "begin/{solutionId}";
    public static final String PUT_SOLUTION_SUMMARY = "Starts updating the solution.";
    public static final String GET_SOLUTION_TASK_RESULT_PATH = "result/{taskId}";
    public static final String GET_SOLUTION_TASK_RESULT_SUMMARY = "Gets the result of the create solution task.";
    public static final String DELETE_SOLUTION_PATH = "{solutionId}";
    public static final String DELETE_SOLUTION_SUMMARY = "Deletes the specified solution.";
    public static final String GET_PROPERTIES_PATH = "properties/{solutionId}";
    public static final String GET_PROPERTIES_SUMMARY = "Gets the solution's properties.";
    public static final String GET_PROPERTIES_VERSION_PATH = "properties/{solutionId}/{version}";
    public static final String GET_PROPERTIES_VERSION_SUMMARY = "Gets the specified version of the solution's properties.";
    public static final String PUT_PROPERTIES_PATH = "properties/{solutionId}";
    public static final String PUT_PROPERTIES_SUMMARY = "Updates the solution's properties.";
    public static final String GET_STATISTICS_PATH = "statistics/{solutionId}";
    public static final String GET_STATISTICS_SUMMARY = "Gets the solution's statistics.";
    public static final String GET_OWNERS_PATH = "owners/{solutionId}";
    public static final String GET_OWNERS_SUMMARY = "Gets the solution's owners.";
    public static final String PUT_OWNERS_PATH = "owners/{solutionId}";
    public static final String PUT_OWNERS_SUMMARY = "Updates the solution's owners.";
    public static final String POST_EXPORT_BEGIN_PATH = "export/begin/{solutionId}";
    public static final String POST_EXPORT_BEGIN_SUMMARY = "Starts exporting the specified solution.";
    public static final String GET_EXPORT_RESULT_PATH = "export/result/{taskId}";
    public static final String GET_EXPORT_RESULT_SUMMARY = "Gets the file resulting from a solution export task.";

    public List<Solution> getSolutions(boolean var1) throws ResourceException;

    public Solution getSolution(UUID var1) throws ResourceException;

    public UUID beginCreateSolution(InputStream var1, Solution var2, boolean var3, UUID var4) throws ResourceException;

    public UUID beginUpdateSolution(UUID var1, InputStream var2, Solution var3) throws ResourceException;

    public Collection<Report> getSolutionTaskResult(UUID var1) throws ResourceException;

    public void deleteSolution(UUID var1) throws ResourceException;

    public SolutionProperties getProperties(UUID var1) throws ResourceException;

    public SolutionProperties getPropertiesVersion(UUID var1, String var2) throws ResourceException;

    public SolutionProperties updateProperties(UUID var1, SolutionProperties var2) throws ResourceException;

    public SolutionStatistics getSolutionStatistics(UUID var1) throws ResourceException;

    public List<User> getSolutionOwners(UUID var1) throws ResourceException;

    public List<User> updateSolutionOwners(UUID var1, List<UUID> var2) throws ResourceException;

    public UUID beginExportSolution(UUID var1) throws ResourceException;

    public InputStream getExportSolutionResult(UUID var1) throws ResourceException;
}

