/*
 * Decompiled with CFR 0.152.
 */
package com.artisol.teneo.studio.api.resources;

import com.artisol.teneo.studio.api.exceptions.ResourceException;
import com.artisol.teneo.studio.api.models.StableVersions;
import java.util.Set;
import java.util.UUID;

public interface StableVersionsResource {
    public static final String PATH = "stable-versions";
    public static final String GET_PATH = "{solutionId}";
    public static final String GET_SUMMARY = "Gets a list of the solution's stable documents.";
    public static final String GET_DOCUMENT_VERSIONS_PATH = "{solutionId}/{documentId}";
    public static final String GET_DOCUMENT_VERSIONS_SUMMARY = "Gets all stable versions of the document; i.e., versions where the document has been set to stable.";
    public static final String POST_SET_SOLUTION_REVISION_PATH = "set/{solutionId}/{revision:\\d+}";
    public static final String POST_SET_SOLUTION_REVISION_SUMMARY = "Sets all documents of the specified solution revision to stable.";
    public static final String POST_SET_DOCUMENT_VERSION_PATH = "set/{solutionId}/{documentId}/{version}";
    public static final String POST_SET_DOCUMENT_VERSION_SUMMARY = "Sets the specified version of the document to stable.";
    public static final String POST_SET_DOCUMENT_LATEST_PATH = "set/{solutionId}/{documentId}";
    public static final String POST_SET_DOCUMENT_LATEST_SUMMARY = "Sets the latest version of the specified document to stable.";
    public static final String POST_UNSET_DOCUMENT_PATH = "unset/{solutionId}/{documentId}";
    public static final String POST_UNSET_DOCUMENT_SUMMARY = "Unsets a document's stable version.";
    public static final String POST_UNSET_SOLUTION_PATH = "unset/{solutionId}";
    public static final String POST_UNSET_SOLUTION_SUMMARY = "Unsets the stable version of a solution.";
    public static final String POST_SET_SOLUTION_FOLDER_PATH = "folder/set/{solutionId}";
    public static final String POST_SET_SOLUTION_FOLDER_SUMMARY = "Sets the content of the solution folder to stable.";
    public static final String POST_SET_FOLDER_PATH = "folder/set/{solutionId}/{folderId}";
    public static final String POST_SET_FOLDER_SUMMARY = "Sets the content of the specified folder to stable.";
    public static final String POST_UNSET_SOLUTION_FOLDER_PATH = "folder/unset/{solutionId}";
    public static final String POST_UNSET_SOLUTION_FOLDER_SUMMARY = "Unsets the stable version of the solution folder's content.";
    public static final String POST_UNSET_FOLDER_PATH = "folder/unset/{solutionId}/{folderId}";
    public static final String POST_UNSET_FOLDER_SUMMARY = "Unsets the stable version of specified folder's content.";

    public StableVersions getStableVersions(UUID var1) throws ResourceException;

    public void setDocumentStable(UUID var1, UUID var2, String var3) throws ResourceException;

    public void setDocumentStable(UUID var1, UUID var2) throws ResourceException;

    public void setFolderStable(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public void setSolutionFolderStable(UUID var1, boolean var2) throws ResourceException;

    public void setSolutionStable(UUID var1, long var2) throws ResourceException;

    public void unsetDocumentStable(UUID var1, UUID var2) throws ResourceException;

    public void unsetFolderStable(UUID var1, UUID var2, boolean var3) throws ResourceException;

    public void unsetSolutionFolderStable(UUID var1, boolean var2) throws ResourceException;

    public void unsetSolutionStable(UUID var1) throws ResourceException;

    public Set<String> getStableVersionsForDocument(UUID var1, UUID var2) throws ResourceException;
}

